<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_latest
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

if (!$list) {
    return;
}

?>
<ul class="mod-articleslatest latestnews mod-list">
<?php foreach ($list as $item) : ?>
    <?php
        $jcfields = FieldsHelper::getFields('com_content.article', $item, true);
        foreach($jcfields as $jcfield) {
            $jcfields[$jcfield->name] = $jcfield;
        }
        $iconClass = implode(',',$jcfields['icon']->rawvalue);;
    ?>
    <li itemscope itemtype="https://schema.org/Article">
        <?php if(!empty($iconClass)) : ?>
            <span class="<?php echo $iconClass; ?>" aria-hidden="true"></span>
        <?php endif; ?>
        <a href="/<?php echo $item->link; ?>" itemprop="url">
            <span itemprop="name">
                <?php echo $item->title; ?>
            </span>
        </a>
    </li>
<?php endforeach; ?>
</ul>
